package w83b.w83bOperacionesPaso.w83bListados.w83bImpugnaciones;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bListImpugnacionesBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaRelImpugnacionesExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListRelImpugnaciones.xls";
		InputStream inputStream = W83bTablaRelImpugnacionesExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaImpugnaciones = (ArrayList)contexto.get("W83bListImpugnacionesBean");
        W83bListImpugnacionesBean listadoRelBean = (W83bListImpugnacionesBean)contexto.get("W83bListadosImpugBean");                      
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                      

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                      
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                      
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                      
        
        HashMap mapaRelImpugn=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                      
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1                      
        HSSFCell cell = row.createCell((short)3);                      
        row = sheet.getRow((short)4);                      
        cell = row.getCell((short)4);                      
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaRelImpugn.get("tituloDepEs");                      
        StringBuffer tituloImagenEu =  (StringBuffer)mapaRelImpugn.get("tituloDepEu");                      
        cell.setCellValue(tituloImagenEu.toString());                      
        
        cell = row.getCell((short)7);                      
        cell.setCellValue(tituloImagenEs.toString());                      
        
        tituloImagenEs = (StringBuffer)mapaRelImpugn.get("tituloDelelegacionEs");                      
        tituloImagenEu = (StringBuffer)mapaRelImpugn.get("tituloDelelegacionEu");                      
        
        row = sheet.getRow((short)6);                      
        cell = row.getCell((short)4);                      
        cell.setCellValue(tituloImagenEu.toString());                      
        
        cell = row.getCell((short)7);                      
        cell.setCellValue(tituloImagenEs.toString());                      
        
        row = sheet.getRow((short)9);                      
        cell = row.getCell((short)0);                      
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.listados.impugRel",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.listados.impugRel",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());                      
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)12);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.territorio"));
        cell = row.createCell((short)3); 
        if(StringUtils.isNotEmpty(listadoRelBean.getDescTerritorio())){
        	cell.setCellValue(listadoRelBean.getDescTerritorio().toUpperCase());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        cell = row.getCell((short)5);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fimpugdesde"));
        cell = row.createCell((short)8); 
        if(StringUtils.isNotEmpty(listadoRelBean.getFechaEntradaDesde())){
        	cell.setCellValue(listadoRelBean.getFechaEntradaDesde());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        cell = row.getCell((short)10);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fimpughasta"));
        cell = row.createCell((short)13); 
        if(StringUtils.isNotEmpty(listadoRelBean.getFechaEntradaHasta())){
        	cell.setCellValue(listadoRelBean.getFechaEntradaHasta());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow((short)15);
        cell = row.getCell((short)0);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.nImpugnacionCorto"));
        
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.timpug"));
        
        cell = row.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.impugnaciones.fImpugnacionCorto"));
        
        cell = row.getCell((short)3);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.nEntrada"));
        
        cell = row.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.fech_entrada"));
        
        cell = row.getCell((short)5);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.razonSocial"));
        
        cell = row.getCell((short)8);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.registroDefinitivo.direccion"));
        
        cell = row.getCell((short)12);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.observaciones"));
        
        for(int i=0;i<listaImpugnaciones.size();i++){
        	
        	String clase = (String)listaImpugnaciones.get(i).getClass().getName();
        	W83bActasBean acta = null;
        	W83bPreavisosBean preav =null;
        	if("w83b.w83bBeans.W83bActasBean".equalsIgnoreCase(clase)){
        		acta = (W83bActasBean)listaImpugnaciones.get(i);
        	}else if("w83b.w83bBeans.W83bPreavisosBean".equalsIgnoreCase(clase)){
        		preav = (W83bPreavisosBean)listaImpugnaciones.get(i);
        	}
        	
        	// Creacin de la fila 1
        	row = sheet.createRow((short)W83bClsConstantes.DIECISEIS+i);
        	cell = row.createCell((short)0);
        	if(acta!=null){
        		cell.setCellValue(acta.getTerritorioActaTotal()+"/"+acta.getAgnoImpug()+"/"+W83bUtilidadesComunes.rellenarCeros(acta.getNumImpug()));
        	}else{
        		cell.setCellValue(preav.getCodTerritorio()+"/"+preav.getAgnoImpug()+"/"+W83bUtilidadesComunes.rellenarCeros(preav.getNumImpug()));
        	}
        	cell.setCellStyle(styleCentrado(i,excel));
        	
        	// Creacin de la fila 2
        	cell = row.createCell((short)1);
        	if(acta!=null){
        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.menu.actas",idioma).toUpperCase());
        	}else{
        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.menu.preavisos",idioma).toUpperCase());
        	}
        	cell.setCellStyle(styleCentrado(i,excel));
        	
        	// Creacin de la fila 3
        	cell = row.createCell((short)2);
        	//la fecha la recibo como tipo char (fecha(yyyy-MM-dd) + hora) asi que lo formateo a mi gusto
        	String fechaChar= null;
        	if(acta!=null){
        		fechaChar = acta.getFechaImpug();
        	}else{
        		fechaChar = preav.getFechaImpug();
        	}
            cell.setCellValue(fechaChar);
        	cell.setCellStyle(styleCentrado(i,excel));
        	
        	// Creacin de la fila 4
        	cell = row.createCell((short)3);
        	if(acta!=null){
        		cell.setCellValue(acta.getTerritorioActaTotal()+"/"+acta.getAnyoActaTotal()+"/"+W83bUtilidadesComunes.rellenarCeros(acta.getNumActa()));
        	}else{
        		cell.setCellValue(preav.getCodTerritorio()+"/"+preav.getAnyoPreaviso()+"/"+W83bUtilidadesComunes.rellenarCeros(preav.getNumPreaviso_completo()));
        	}
        	cell.setCellStyle(styleCentrado(i,excel));
        	
        	// Creacin de la fila 4
        	cell = row.createCell((short)4);
        	fechaChar= null;
        	if(acta!=null){
        		fechaChar = acta.getFechaEntrada();
        	}else{
        		fechaChar = preav.getFecha_entrada();
        	}
        	cell.setCellValue(fechaChar);
        	cell.setCellStyle(styleCentrado(i,excel));
        	
        	// Creacin de la fila 5
        	cell = row.createCell((short)5);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+i,Short.parseShort("5"),W83bClsConstantes.DIECISEIS+i,Short.parseShort("7")));//NOPMD
        	if(acta!=null){
        		if(acta.getRazonSocial()!=null){
        			cell.setCellValue(acta.getRazonSocial().toUpperCase());
        		}else{
        			cell.setCellValue(acta.getRazonSocial());
        		}
        	}else{
        		if(StringUtils.isNotEmpty(preav.getRazonSocialPreaviso())){
        			cell.setCellValue(preav.getRazonSocialPreaviso().toUpperCase());
        		}else{
        			cell.setCellValue("");        			
        		}
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)6);
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)7);
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	// Creacin de la fila 6
        	cell = row.createCell((short)8);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+i,Short.parseShort("8"),W83bClsConstantes.DIECISEIS+i,Short.parseShort("11")));//NOPMD
        	if(acta!=null){
        		if(acta.getDomicilio()!=null){
        			cell.setCellValue(acta.getDomicilio().toUpperCase());
        		}else{
        			cell.setCellValue(acta.getDomicilio());
        		}
        	}else{
        		if(preav.getDomicilioPreaviso()!=null){
        			cell.setCellValue(preav.getDomicilioPreaviso().toUpperCase());
        		}else{
        			cell.setCellValue(preav.getDomicilioPreaviso());
        		}
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)9);
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)10);
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)11);
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	// Creacin de la fila 7
        	cell = row.createCell((short)12);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS+i,Short.parseShort("12"),W83bClsConstantes.DIECISEIS+i,Short.parseShort("14")));//NOPMD
        	if(acta!=null){
        		if(acta.getObservaciones()!=null){
        			cell.setCellValue(acta.getObservaciones().toUpperCase());
        		}else{
        			cell.setCellValue(acta.getObservaciones());
        		}
        	}else{
        		if(preav.getObservaciones()!=null){
        			cell.setCellValue(preav.getObservaciones().toUpperCase());
        		}else{
        			cell.setCellValue(preav.getObservaciones());
        		}
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)13);
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)14);
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	String obs = "";
    		String rsc = "";
        if(acta!=null){
        		if(acta.getObservaciones()!=null){
        			obs = acta.getObservaciones();
        		}
        		if(acta.getRazonSocial()!=null){
        			rsc = acta.getRazonSocial();
        		}
        		if(obs.length()>=rsc.length()){
    	        	if(56<obs.length()){
    	        		row.setHeightInPoints((short)(20*(obs.length()/56)+1));
    	        	}
    	        }else{
    	        	if(44<rsc.length()){
    	        		row.setHeightInPoints((short)(20*(rsc.length()/44)+1));
    	        	}
    	        }
        	}else{
        		if(preav.getObservaciones()!=null){
        			obs = preav.getObservaciones();
        		}
        		if(preav.getRazonSocialPreaviso()!=null){
        			rsc = preav.getRazonSocialPreaviso();
        		}
        		if(obs.length()>=rsc.length()){
    	        	if(56<obs.length()){
    	        		row.setHeightInPoints((short)(20*(obs.length()/56)+1));
    	        	}
    	        }else{
    	        	if(44<rsc.length()){
    	        		row.setHeightInPoints((short)(20*(rsc.length()/44)+1));
    	        	}
    	        }
        	}	
        }
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoRelacionActasImpugnadas.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();
		
		return null;
	}
	
	/**
	 * Estilo fila.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	/**
	 * Style centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle styleCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParCentrado;	
		}else{
			return excel.styleTextoImparCentrado;		
		}
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
	
}
